// Function to validate input (Allow alphanumeric, spaces, and -_/.,#)
const validateInput = (input) => {
  const regex = /^[a-zA-Z0-9 \-_/.,#]*$/; // Allow only alphanumeric characters, spaces, and (-_/.,#)
  return regex.test(input);
};

const handleSanitizeInputFields = (rawValue) => {
  if (validateInput(rawValue)) {
    return true;
  } else {
    // Return null if the input doesn't pass validation
    return false;
  }
};
module.exports = {
  handleSanitizeInputFields,
};
