const tables = require("../utils/tables");
const { performQuery } = require("../utils/db");
const { sendResponse, sendErrorResponse } = require("../utils/");
const { handleSanitizeInputFields } = require("../utils/SanitizeInputFields");

//===> Create api
module.exports.createDefectType = async (req, res) => {
  try {
    const { type } = req.body;

    if (!type) {
      const error = new Error("Fields are required");
      console.error("Validation Error:", error.message);
      return sendErrorResponse(res, error, "Fields are required");
    }

    // check special character to avoid them
    const isDataSafe = handleSanitizeInputFields(type);
    if (!isDataSafe) {
      const error = new Error("This Characters is prohibited");
      return sendErrorResponse(res, error, "This Characters is prohibited");
    }

    const insertQuery = `INSERT INTO ${tables.tables.defectType} SET ?`;
    const insertParams = { type };

    console.log("Insert Parameters:", insertParams);

    const result = await performQuery(insertQuery, insertParams);

    if (result) {
      console.log("Type created successfully:", result);
      sendResponse(res, "Type successfully created");
    } else {
      throw new Error("Failed to create Type, no result returned");
    }
  } catch (error) {
    console.error("Internal Server Error:", error.message);
    return sendErrorResponse(res, error, "Error while creating Type");
  }
};

//======> Select API for All (Add ActiveStatus in Select) <=====
module.exports.getDefectTypes = async (req, res) => {
  let { activeStatus } = req.query;
  try {
    const selectdefectType = `SELECT * FROM  ${tables.tables.defectType} order By id DESC`;
    const active = `SELECt * FROM ${tables.tables.defectType} WHERE activeStatus = 1 order by id DESC`;
    const nonActive = `SELECT * FROm ${tables.tables.defectType} WHERE activeStatus = 0 order by id DESC`;
    // const selectdefectTypeActiveStatus = `SELECT * FROM ${tables.defectType} WHERE activeStatus=1 order By id DESC`;
    // const selectdefectTypeNonActiveStatus = `SELECT * FROM ${tables.defectType} WHERE activeStatus=0 order By id DESC`;

    let query = "";
    if (activeStatus) {
      query = activeStatus === "1" ? active : nonActive;
    } else {
      query = selectdefectType;
    }
    // let q = "";
    // if(activeStatus){
    //   q =
    //     activeStatus === "0"
    //       ? selectdefectTypeNonActiveStatus
    //       : selectdefectTypeActiveStatus;
    // } else{
    //   q = selectdefectType;
    // }
    // if(activeStatus){
    //   query =
    //     activeStatus === "1"
    //       ? selectdefectTypeActiveStatus
    //       : selectdefectTypeNonActiveStatus;
    // } else{
    //   query = selectdefectType;
    // }
    // const defectType = await performQuery(selectdefectType);
    const defectType = await performQuery(query);

    return sendResponse(res, defectType, "Fetch defectType Successfully", 200);
  } catch (error) {
    return sendErrorResponse(res, error, "Error while fatching defectType");
  }
};

//===> Select api for specific
module.exports.getDefectType = async (req, res) => {
  try {
    const { id } = req.params;
    if (!id) {
      const error = new Error("Id is required");
      return sendErrorResponse(res, error, "Id is reuired");
    }
    const selectdefectType = `SELECT * FROM ${tables.tables.defectType} WHERE id=${id}`;
    // ==> perform the database query
    const defectType = await performQuery(selectdefectType);
    return sendResponse(
      res,
      defectType,
      "Fatch defectType data sucessfully",
      200
    );
  } catch (error) {
    return sendErrorResponse(res, error, "Error while fatching defectType");
  }
};

//====> update Api
module.exports.updateDefectType = async (req, res) => {
  try {
    // const { id } = req.params;
    const { id, type } = req.body;

    // check this record is exist in defect table
    const selectDefectRecord = `SELECT * FROM  ${tables.tables.defects} WHERE defectType_Id=${id}`;
    const defectRecord = await performQuery(selectDefectRecord);

    // if block run only when the provided id exist in defect table
    if (defectRecord.length > 0) {
      const error = new Error(
        "This part exists in the defect table and cannot be updated."
      );
      return sendErrorResponse(
        res,
        error,
        "This part exists in the defect table and cannot be updated.",
        201
      );
    } else {
      // else block run only when the provided id not exist in defect table
      // ===> check for empty fields
      if (!id || !type) {
        const error = new Error("Id and type are required");
        return sendErrorResponse(res, error, "Id and type are required");
      }
      // check special character to avoid them
      const isDataSafe = handleSanitizeInputFields(type);
      if (!isDataSafe) {
        const error = new Error("This Characters is prohibited");
        return sendErrorResponse(res, error, "This Characters is prohibited");
      }
    }

    //====> perform query <=====
    const updateQuery = `UPDATE ${tables.tables.defectType} SET type = ? WHERE id = ?`;
    const updateParams = [type, id];

    console.log("Update Parameters:", updateParams);

    const result = await performQuery(updateQuery, updateParams);
    if (result) {
      return sendResponse(res, result, "Type update successfully", 201);
    }
  } catch (error) {
    console.error("Internal Server Error:", error.message);
    return sendErrorResponse(res, error, "Error while updating Type");
  }
};

//====> update status Api for defect type =================
module.exports.updateDefectTypeStatus = async (req, res) => {
  try {
    const { id, activeStatus } = req.body;

    // ===> check for empty fields
    if (!id || ![0, 1].includes(activeStatus)) {
      const error = new Error("Fields are required");
      return sendErrorResponse(res, error, "Fields are required");
    }
    const updateQuery = `UPDATE ${tables.tables.defectType} SET activeStatus=? WHERE id=?`;
    const updateParams = [activeStatus, id];

    //==> perform the database query
    const result = await performQuery(updateQuery, updateParams);
    if (result) {
      return sendResponse(res, result, "Type status update successfully", 201);
    }
  } catch (error) {
    console.log("Error in updating data");
    return sendErrorResponse(res, error, "Error while updating Type status");
  }
};


//====> Delete Api
module.exports.deleteDefectType = async (req, res) => {
  try {
    // const { id } = req.params;
    const { id } = req.query;

    if (!id) {
      const error = new Error("Id is required");
      console.error("Validation Error:", error.message);
      return sendErrorResponse(res, error, "Id is required");
    }

    // check this record is exist in defect table
    const selectDefectRecord = `SELECT * FROM  ${tables.tables.defects} WHERE defectType_Id=${id}`;
    const defectRecord = await performQuery(selectDefectRecord);

    // if block run only when the provided id exist in defect table
    if (defectRecord.length > 0) {
      const error = new Error(
        `This part exists in the defect table and cannot be deleted.`
      );
      return sendErrorResponse(
        res,
        error,
        `This part exists in the defect table and cannot be deleted.`,
        201
      );
    } else {
      // else block run only when the provided id exist in defect table

      // Delete
      const deleteQuery = `DELETE FROM ${tables.tables.defectType} WHERE id = ?`;
      const deleteParams = [id];

      console.log("Delete Parameters:", deleteParams);

      const result = await performQuery(deleteQuery, deleteParams);

      if (result) {
        console.log("Type deleted successfully");
        sendResponse(res, "Type deleted successfully");
      } else {
        throw new Error("Failed to delete Type, no rows affected");
      }
    }
  } catch (error) {
    console.error("Internal Server Error:", error.message);
  }
};
