const tables = require("../utils/tables");
const { performQuery } = require("../utils/db");
const { sendResponse, sendErrorResponse } = require("../utils");
const { handleSanitizeInputFields } = require("../utils/SanitizeInputFields");

//======> Create API
module.exports.createDefectPart = async (req, res) => {
  try {
    const { equip_Id, part, line_id } = req.body;
    console.log("req body", req.body);
    if (!equip_Id || !part) {
      const error = new Error("Fields are required");
      return sendErrorResponse(res, error, "Fields are required");
    }
    // check special character to avoid them
    const isDataSafe = handleSanitizeInputFields(part);
    if (!isDataSafe) {
      const error = new Error("This Characters is prohibited");
      return sendErrorResponse(res, error, "This Characters is prohibited");
    }

    // const createDefectPart = `INSERT INTO ${tables.defectPart} (equip_id, part) VALUES (?, ?, ?)`
    const createDefectPart = `INSERT INTO ${tables.tables.defectPart} SET ?`;
    const values = { equip_Id, part, line_id };
    const defectPart = await performQuery(createDefectPart, values);
    return sendResponse(res, defectPart, "created successfully", 201);
  } catch (error) {
    console.error("Error:", error.message);
    return sendErrorResponse(res, error, "Error creating defect part");
  }
};

//======> Select API for All (Add ActiveStatus in Select) <=====
module.exports.getDefectParts = async (req, res) => {
  let { activeStatus } = req.query;
  try {
    const selectDefectParts = `
    SELECT 
    d.id,
    d.equip_Id,
    d.part, 
    d.activeStatus,
    d.line_id,
    l.line,
    (SELECT a.equipment from ${tables.tables.equipmentFromAD} 
    AS a WHERE a.id=d.equip_Id) 
    As equipmentName from ${tables.tables.defectPart} as d 
    left join ${tables.tables.lineFromAD} as l on d.line_id=l.id
    order by id DESC;`;

    // const selectDefectParts = `SELECT * FROM ${tables.defectPart} order by id DESC`;

    // const active = `SELECT d.id,d.equip_Id,d.part, d.activeStatus,(SELECT a.equipment from ${tables.equipmentFromAD} AS a WHERE a.id=d.equip_Id) As equipmentName from ${tables.defectPart} WHERE activeStatus=1 as d order by id DESC;`;
    // const nonActive = `SELECT d.id,d.equip_Id,d.part, d.activeStatus,(SELECT a.equipment from ${tables.equipmentFromAD} AS a WHERE a.id=d.equip_Id) As equipmentName from ${tables.defectPart} WHERE activeStatus=0 as d order by id DESC;`;

    const active = `SELECT * FROM ${tables.tables.defectPart} WHERE activeStatus=1  order by id DESC;`;
    const nonActive = `SELECT * FROM ${tables.tables.defectPart} WHERE activeStatus=0 order by id DESC;`;

    let query = "";
    if (activeStatus) {
      query = activeStatus === "1" ? active : nonActive;
    } else {
      query = selectDefectParts;
    }
    const defectParts = await performQuery(query);
    // const defectParts = await performQuery(selectDefectParts);
    return sendResponse(res, defectParts, "fetch successfully", 200);
  } catch (error) {
    console.error("Error:", error.message);
    return sendErrorResponse(res, error, "Error fetching defect parts");
  }
};

//======> Select API for Single
module.exports.getDefectPart = async (req, res) => {
  try {
    const { id } = req.params;
    if (!id) {
      const error = new Error("Id is required");
      console.error("Validation Error:", error.message);
      return sendErrorResponse(res, error, "Id is required");
    }
    const selectDefectPart = `SELECT * FROM ${tables.tables.defectPart} WHERE id=${id}`;
    const defectPart = await performQuery(selectDefectPart);
    return sendResponse(res, defectPart, "fetch defectPart successfully", 200);
  } catch (error) {
    console.error("Error:", error.message);
    return sendErrorResponse(res, error, "Error fetching defect part by id");
  }
};



// module.exports.createdefectPart = async (req, res) => {
//   try {
//     const { equip_Id, part } = req.body;
//     if (!equip_Id || !part) {
//       const error = new Error("Fields are required");
//       return sendErrorResponse(res, error, "Fields are required");
//     }
//     // check special character to avoid them
//     const isDataSafe = handleSanitizeInputFields(part);
//     if (!isDataSafe) {
//       const error = new Error("This Characters is prohibited");
//       return sendErrorResponse(res, error, "This Characters is prohibited");
//     }

//     // const createDefectPart = `INSERT INTO ${tables.defectPart} (equip_id, part) VALUES (?, ?, ?)`
//     const createDefectPart = `INSERT INTO ${tables.defectPart} SET ?`;
//     const values = { equip_Id, part };
//     const defectPart = await performQuery(createDefectPart, values);
//     return sendResponse(res, defectPart, "created successfully", 201);
//   } catch (error) {
//     console.error("Error:", error.message);
//     return sendErrorResponse(res, error, "Error creating defect part");
//   }
// };

//===> Update Api
module.exports.updateDefectPart = async (req, res) => {
  try {
    const { id, equip_Id, part, line_id } = req.body;

    // check this record is exist in defect table
    const selectDefectRecord = `SELECT * FROM  ${tables.tables.defects} WHERE defectPart_Id=${id}`;
    const defectRecord = await performQuery(selectDefectRecord);

    // if block run only when the provided id exist in defect table
    if (defectRecord.length > 0) {
      const error = new Error(
        "This part exists in the defect table and cannot be updated."
      );
      return sendErrorResponse(
        res,
        error,
        "This part exists in the defect table and cannot be updated.",
        201
      );
    } else {
      // else block run only when the provided id not exist in defect table
      // ===> check for empty fields
      if ((!equip_Id, !part)) {
        const error = new Error("Fields are required");
        return sendErrorResponse(res, error, "Fields are required");
      }
      // check special character to avoid them
      const isDataSafe = handleSanitizeInputFields(part);
      if (!isDataSafe) {
        const error = new Error("This Characters is prohibited");
        return sendErrorResponse(res, error, "This Characters is prohibited");
      }

      // ===> for limited data
      const updateQuery = `UPDATE ${tables.tables.defectPart} SET equip_Id=?, part=?, line_id=? WHERE id=?`;
      const updateParams = [equip_Id, part, line_id, id];

      //==> perform the database query
      const result = await performQuery(updateQuery, updateParams);
      if (result) {
        return sendResponse(res, result, "part update successfully", 201);
      }
    }
  } catch (error) {
    console.log("Error in updating data");
    return sendErrorResponse(res, error, "Error while updating part");
  }
};

//===> Ststus Update Api
module.exports.updateDefectPartStatus = async (req, res) => {
  try {
    const { id, activeStatus } = req.body;

    // ===> check for empty fields
    if (!id || ![0, 1].includes(activeStatus)) {
      const error = new Error("Fields are required");
      return sendErrorResponse(res, error, "Fields are required");
    }

    // ===> for limited data
    const updateQuery = `UPDATE ${tables.tables.defectPart} SET activeStatus=? WHERE id=?`;
    const updateParams = [activeStatus, id];

    //==> perform the database query
    const result = await performQuery(updateQuery, updateParams);
    if (result) {
      return sendResponse(res, result, "part status update successfully", 201);
    }
  } catch (error) {
    console.log("Error in updating data");
    return sendErrorResponse(res, error, "Error while updating part status");
  }
};

//====> Delete Api
module.exports.deleteDefectPart = async (req, res) => {
  try {
    const { id } = req.query;
    // ===> check for empty fields
    if (!id) {
      const error = new Error("id is required");
      return sendErrorResponse(res, error, "id is required");
    }

    // check this record is exist in defect table
    const selectDefectRecord = `SELECT * FROM  ${tables.tables.defects} WHERE defectPart_Id=${id}`;
    const defectRecord = await performQuery(selectDefectRecord);

    // if block run only when the provided id exist in defect table
    if (defectRecord.length > 0) {
      const error = new Error(
        `This part exists in the defect table and cannot be deleted.`
      );
      return sendErrorResponse(
        res,
        error,
        `This part exists in the defect table and cannot be deleted.`,
        201
      );
    } else {
      // else block run only when the provided id exist in defect table

      // Delete
      const deleteQuery = `DELETE FROM ${tables.tables.defectPart} WHERE id = ?`;
      const deleteParams = [id];

      // Perform the database query
      const result = await performQuery(deleteQuery, deleteParams);
      if (result) {
        return sendResponse(res, result, "part deleted successfully", 201);
      }
    }
  } catch (error) {
    console.log(error);
    return sendErrorResponse(res, error, "Error while deleting part");
  }
};