const tables = require("../utils/tables");
const { performQuery } = require("../utils/db");
const { sendResponse, sendErrorResponse } = require("../utils");
const { handleSanitizeInputFields } = require("../utils/SanitizeInputFields");


//===> Create api
module.exports.createDefectCategory = async (req, res) => {
  try {
    // check empty fields
    const { category } = req.body;
    if (!category) {
      const error = new Error("Fields are required");
      return sendErrorResponse(res, error, "Fields are required");
    }
    // check special character to avoid them
    const isDataSafe = handleSanitizeInputFields(category);
    if (!isDataSafe) {
      const error = new Error("This Characters is prohibited");
      return sendErrorResponse(res, error, "This Characters is prohibited");
    }
    // query work
    const insertQuery = `INSERT INTO ${tables.tables.defectCategory} SET ?`;
    const insertParams = { category };

    console.log("Insert Parameters:", insertParams);

    const result = await performQuery(insertQuery, insertParams);

    if (result) {
      console.log("Category created successfully:", result);
      sendResponse(res, "Category successfully created");
    } else {
      throw new Error("Failed to create category, no result returned");
    }
  } catch (error) {
    console.error("Internal Server Error:", error.message);
    return sendErrorResponse(res, error, "Error while creating category");
  }
};

// ===> get api for all
module.exports.getDefectCategories = async (req, res) => {
  let { activeStatus } = req.query;
  try {
    const selectdefectCategory = `SELECT * FROM ${tables.tables.defectCategory}  order By id DESC`;
    const selectdefectCategoryActive = `SELECT * FROM ${tables.tables.defectCategory} WHERE activeStatus=1  order By id DESC`;
    const selectdefectCategoryNonActive = `SELECT * FROM ${tables.tables.defectCategory} WHERE activeStatus=0  order By id DESC`;
    // const selectdefectCategory = `SELECT * FROM  ${tables.defectCategory} order By id ASC`;
    let query = "";
    if (activeStatus) {
      query =
        activeStatus === "1"
          ? selectdefectCategoryActive
          : selectdefectCategoryNonActive;
    } else {
      query = selectdefectCategory;
    }
    const defectCategory = await performQuery(query);
    return sendResponse(
      res,
      defectCategory,
      "Fetch defectCategory Successfully",
      200
    );
  } catch (error) {
    return sendErrorResponse(res, error, "Error while fatching defectCategory");
  }
};

//===> get api for specific
module.exports.getDefectCategory = async (req, res) => {
  try {
    const { id } = req.params;
    if (!id) {
      const error = new Error("Id is required");
      return sendErrorResponse(res, error, "Id is reuired");
    }
    const selectdefectCategory = `SELECT * FROM ${tables.tables.defectCategory} WHERE id=${id}`;
    // ==> perform the database query
    const defectCategory = await performQuery(selectdefectCategory);
    return sendResponse(
      res,
      defectCategory,
      "Fatch defectCategory data sucessfully",
      200
    );
  } catch (error) {
    return sendErrorResponse(res, error, "Error while fatching defectCategory");
  }
};


//===> Update Api
module.exports.updateDefectCategory = async (req, res) => {
  try {
    const { id, category } = req.body;

    // check this record is exist in defect table
    const selectDefectRecord = `SELECT * FROM  ${tables.tables.defects} WHERE defectCategory_Id=${id}`;
    const defectRecord = await performQuery(selectDefectRecord);
    
    // if block run only when the provided id exist in defect table
    if (defectRecord.length > 0) {
      const error = new Error(
        "This category exists in the defect table and cannot be updated."
      );
      return sendErrorResponse(
        res,
        error,
        "This category exists in the defect table and cannot be updated.",
        201
      );
    } else {
      // else block run only when the provided id not exist in defect table
      // ===> check for empty fields
      if (!category) {
        const error = new Error("Fields are required");
        return sendErrorResponse(res, error, "Fields are required");
      }

      // check special character to avoid them
      const isDataSafe = handleSanitizeInputFields(category);
      if (!isDataSafe) {
        const error = new Error("This Characters is prohibited");
        return sendErrorResponse(res, error, "This Characters is prohibited");
      }

      // ===> for limited data
      const updateQuery = `UPDATE ${tables.tables.defectCategory} SET category=? WHERE id=?`;
      const updateParams = [category, id];
      
      //==> perform the database query
      const result = await performQuery(updateQuery, updateParams);
      if (result) {
        return sendResponse(res, result, "category update successfully", 201);
      }
    }
  } catch (error) {
    console.log("Error in updating data");
    return sendErrorResponse(res, error, "Error while updating category");
  }
};

//===> Ststus Update Api
module.exports.updateDefectCategoryStatus = async (req, res) => {
  try {
    const { id, activeStatus } = req.body;

    // ===> check for empty fields
    if (!id || ![0, 1].includes(activeStatus)) {
      const error = new Error("Fields are required");
      return sendErrorResponse(res, error, "Fields are required");
    }

    // ===> for limited data
    const updateQuery = `UPDATE ${tables.tables.defectCategory} SET activeStatus=? WHERE id=?`;
    const updateParams = [activeStatus, id];

    //==> perform the database query
    const result = await performQuery(updateQuery, updateParams);
    if (result) {
      return sendResponse(
        res,
        result,
        "category status update successfully",
        201
      );
    }
  } catch (error) {
    console.log("Error in updating data");
    return sendErrorResponse(
      res,
      error,
      "Error while updating category status"
    );
  }
};

//====> Delete Api
module.exports.deleteDefectCategory = async (req, res) => {
  try {
    const { id } = req.query;
    // ===> check for empty fields
    if (!id) {
      const error = new Error("id is required");
      return sendErrorResponse(res, error, "id is required");
    }

    // check this record is exist in defect table
    const selectDefectRecord = `SELECT * FROM  ${tables.tables.defects} WHERE defectCategory_Id=${id}`;
    const defectRecord = await performQuery(selectDefectRecord);

    // check this record is exist in users pririoty table
    const selectPriotityRecord = `SELECT * FROM  ${tables.tables.userPriority} WHERE defectCategory_Id=${id}`;
    const usersPriority = await performQuery(selectPriotityRecord);

    // if block run only when the provided id exist in defect & usersPriority table
    if (defectRecord.length > 0 || usersPriority.length > 0) {
      const error = new Error(
        `This category exists in the ${
          defectRecord.length > 0 ? "defect" : "users priority"
        } table and cannot be deleted.`
      );
      return sendErrorResponse(
        res,
        error,
        `This category exists in the ${
          defectRecord.length > 0 ? "defect" : "users priority"
        } table and cannot be deleted.`,
        201
      );
    } else {
      // else block run only when the provided id exist in defect & usersPriority table

      // Delete
      const deleteQuery = `DELETE FROM ${tables.tables.defectCategory} WHERE id = ?`;
      const deleteParams = [id];

      // Perform the database query
      const result = await performQuery(deleteQuery, deleteParams);
      if (result) {
        return sendResponse(res, result, "category deleted successfully", 201);
      }
    }
  } catch (error) {
    console.log(error);
    return sendErrorResponse(res, error, "Error while deleting category");
  }
};